<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// Add to the navbits
$navbits[''] = $pagetitle = $vbphrase['dbtech_vbsignatures_inventory'];

// #############################################################################
if ($_REQUEST['action'] == 'inventory' OR empty($_REQUEST['action']))
{
	$vbulletin->input->clean_array_gpc('r', array(
		'tab'         		=> TYPE_NOHTML,
		'isajax'   			=> TYPE_BOOL,
		'signaturestyleid' 	=> TYPE_UINT,
	));
	
	if (!$signaturestyle = VBSIGNATURES::$cache['signaturestyle'][$vbulletin->GPC['signaturestyleid']])
	{
		// Need a style
		eval(standard_error(fetch_error('dbtech_vbsignatures_error_x', $vbphrase['dbtech_vbsignatures_invalid_action'])));
	}
	
	if (!$signaturestyle['active'])
	{
		// Need a style
		eval(standard_error(fetch_error('dbtech_vbsignatures_error_x', $vbphrase['dbtech_vbsignatures_invalid_action'])));
	}
	
	if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, $signaturestyle['permissions'], 'default'))
	{
		// Need a style
		eval(standard_error(fetch_error('dbtech_vbsignatures_error_x', $vbphrase['dbtech_vbsignatures_invalid_action'])));
	}
	
	if (!file_exists(DIR . '/dbtech/vbsignatures/images/signatures/' . $vbulletin->userinfo['userid'] . '_' . $signaturestyle['signaturestyleid'] . '.png'))
	{
		VBSIGNATURES::createImage(array(), array(), $vbulletin->userinfo['userid'] . '_' . $signaturestyle['signaturestyleid']);
		VBSIGNATURES::createImage(array(), array(), $vbulletin->userinfo['userid'] . '_' . $signaturestyle['signaturestyleid'] . '_preview');
	}
	
	// Grab our inventory
	$inventory = VBSIGNATURES::$db->fetchAllSingleKeyed('SELECT * FROM $dbtech_vbsignatures_inventory WHERE userid = ?', 'partid', 'userid', array($vbulletin->userinfo['userid']));	
	
	$parts_by_category = array();
	foreach ((array)VBSIGNATURES::$cache['part'] as $partid => $part)
	{
		if (!$part['active'])
		{
			// Inactive type
			continue;
		}
		
		if ($part['signaturestyleid'] != $signaturestyle['signaturestyleid'])
		{
			// Inactive type
			continue;
		}
		
		if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, $part['permissions'], 'default'))
		{
			// This item isn't to be displayed
			continue;
		}
		
		if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, VBSIGNATURES::$cache['category'][$part['categoryid']]['permissions'], 'default'))
		{
			// This category isn't to be displayed
			continue;
		}
		
		if ($part['price'] > 0 AND !$inventory[$partid])
		{
			// We don't have this part
			continue;
		}
		
		// Index by categoryid
		$parts_by_category[$part['categoryid']][$partid] = $part;
	}

	if (count($parts_by_category))
	{		
		if (!empty($vbulletin->GPC['tab']) AND isset($parts_by_category[$vbulletin->GPC['tab']]))
		{
			$selected_tab = $vbulletin->GPC['tab'];
		}
		else
		{
			$selected_tab = '';
		}
		
		$firsttab = true;
		$tabbits = '';
		$tabcontent = '';
		foreach ($parts_by_category as $categoryid => $partlist)
		{
			if (!count($partlist))
			{
				// Don't need this showing up
				continue;
			}
			
			// Shorthand
			$category = VBSIGNATURES::$cache['category'][$categoryid];
			
			$i = 1;
			$parts = '';
			foreach ($partlist as $partid => $part)
			{
				// Init this
				$disabled = '';
				
				// Do item bits only if it's in the currently viewing shop
				$templater = vB_Template::create('dbtech_vbsignatures_partbit');
					$templater->register('part', 		$part);
					$templater->register('layer', 		VBSIGNATURES::$cache['layer'][$part['layerid']]);
					$templater->register('disabled', 	$disabled);
				$parts .= $templater->render();
				
				if ($i++ % 5 == 0)
				{
					$parts .= '</tr><tr>';
				}
			}
			
			if (!$parts)
			{
				// We don't need this
				continue;
			}
			
			$templater = vB_Template::create('dbtech_vbsignatures_tabbit');
				$templater->register('firsttab', 		$firsttab);
				$templater->register('selected_tab', 	$selected_tab);			
				$templater->register('category', 		$category);
			$tabbits .= $templater->render();
			
			$templater = vB_Template::create('dbtech_vbsignatures_tabcontent');
				$templater->register('firsttab', 		$firsttab);
				$templater->register('selected_tab', 	$selected_tab);			
				$templater->register('category', 		$category);
				$templater->register('parts', 			$parts);
			$tabcontent .= $templater->render();
			$firsttab = false;
		}
		
		// Do shop bits
		$templater = vB_Template::create('dbtech_vbsignatures_tabs');
			$templater->register('tabbits', 	$tabbits);
			$templater->register('tabcontent', 	$tabcontent);
		$HTML = $templater->render();
	}
	else
	{
		$HTML = $vbphrase['dbtech_vbsignatures_no_parts_frontend'];
	}
	
	$regions = '';
	foreach ((array)VBSIGNATURES::$cache['region'] as $regionid => $region)
	{
		if (!$region['active'])
		{
			// Skip this region
			continue;
		}
		
		if ($region['signaturestyleid'] != $signaturestyle['signaturestyleid'])
		{
			// Inactive type
			continue;
		}		
		
		if ($vbulletin->userinfo['dbtech_vbsignatures_configuration'][$signaturestyle['signaturestyleid']]['regions'][$regionid])
		{
			// Override regiontext
			$region['regiontext'] = $vbulletin->userinfo['dbtech_vbsignatures_configuration'][$signaturestyle['signaturestyleid']]['regions'][$regionid];
		}
		
		if ($vbulletin->userinfo['dbtech_vbsignatures_configuration'][$signaturestyle['signaturestyleid']]['fonts'][$regionid])
		{
			do
			{
				if (!$font = VBSIGNATURES::$cache['font'][$vbulletin->userinfo['dbtech_vbsignatures_configuration'][$signaturestyle['signaturestyleid']]['fonts'][$regionid]])
				{
					// Font doesn't exist
					break;
				}
				
				if (!$font['active'])
				{
					// Inactive font
					break;
				}
				
				if (!$font['cancustom'])
				{
					// Can't be used in custom stuff
					break;
				}
				
				// Override regiontext
				$region['fontid'] = $vbulletin->userinfo['dbtech_vbsignatures_configuration'][$signaturestyle['signaturestyleid']]['fonts'][$regionid];
			}
			while (false);
		}
		
		// Make safe
		$region['regiontext'] = htmlspecialchars_uni($region['regiontext']);		
		
		$fonts = '';
		foreach ((array)VBSIGNATURES::$cache['font'] as $fontid => $font)
		{
			if (!$font['active'])
			{
				// Inactive font
				continue;
			}
			
			if (!$font['cancustom'])
			{
				// Can't be used in custom stuff
				continue;
			}
				
			$templater = vB_Template::create('option');
				$templater->register('optionvalue', 	$fontid);
				$templater->register('optiontitle', 	$font['title']);
				$templater->register('optionselected', 	($region['fontid'] == $fontid ? 'selected="selected"' : ''));
			$fonts .= $templater->render();			
		}
		
		$templater = vB_Template::create('dbtech_vbsignatures_regionbit');
			$templater->register('region', 		$region);
			$templater->register('fonts', 		$fonts);
		$regions .= $templater->render();
	}	
	
	$jsphrases = array(
		'dbtech_vbsignatures_updating_signature' 		=> $vbphrase['dbtech_vbsignatures_updating_signature'],
		'dbtech_vbsignatures_updating_signature_descr' 	=> $vbphrase['dbtech_vbsignatures_updating_signature_descr'],
	);
	
	// Escape them
	VBSIGNATURES::jsEscapeString($jsphrases);
	
	$escapedJsPhrases = '';
	foreach ($jsphrases as $varname => $value)
	{
		// Replace phrases with safe values
		$escapedJsPhrases .= "vbphrase['$varname'] = \"$value\"\n\t\t\t\t\t";
	}
		
	// We can see at least 1 instance
	$footer = VBSIGNATURES::js($escapedJsPhrases . '
			var vBSignatures = {
				current : ' . VBSIGNATURES::encodeJSON($vbulletin->userinfo['dbtech_vbsignatures_configuration'][$signaturestyle['signaturestyleid']]['parts']) . ',
				preview : {},
				usePreview : 0				
			};
	', false, false) . $footer;
	
	$page_templater = vB_Template::create('dbtech_vbsignatures_inventory');
		$page_templater->register('pagetitle', 			$pagetitle);
		$page_templater->register('regions', 			$regions);
		$page_templater->register('signaturestyleid', 	$signaturestyle['signaturestyleid']);
		$page_templater->register('HTML', 				$HTML);
	$HTML = $page_templater->render();
}

// draw cp nav bar
VBSIGNATURES::setNavClass('inventory');

/*======================================================================*\
|| #################################################################### ||
|| # Created: 22:38, Sun Sep 7th 2008								  # ||
|| # SVN: $Rev$									 					  # ||
|| #################################################################### ||
\*======================================================================*/
?>